package w83b.w83bManager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bComunicacionesBean;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bSindicatosBean;
import w83b.w83bDAO.W83bFactoriaDAO;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistro;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

public class W83bComunicaciones implements W83bIComunicaciones {
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bComunicaciones#generarComunicPreaviso(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List generarComunicPreaviso(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
	
		List lista= W83bFactoriaDAO.getComunicacionesDAO().generarComunicPreaviso(param);
		if (!"preaviso".equals(param.getEscomunicacion())){
			return obtenerRestoComunicaciones(param,lista);
		}
		else{
			return obtenerComunicacion(param,lista);
		}
		
	}
	public java.util.List generarComunicIncidencias(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		
		List lista= W83bFactoriaDAO.getComunicacionesDAO().generarComunicIncidencias(param);
		
		if (!"comunicacion".equals(param.getEscomunicacion())){
			return obtenerRestoComunicaciones(param,lista);
		}
		else{
			return obtenerComunicacion(param,lista);
		}
		
	}
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bComunicaciones#generarComunicLibroRegActas(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List generarComunicLibroRegActas(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
	
		List lista= W83bFactoriaDAO.getComunicacionesDAO().generarComunicLibroRegActas(param);
		
		return lista;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bComunicaciones#generarComunicComEmpresas(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List generarComunicComEmpresas(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
	
		List lista=new ArrayList();
		if (W83bClsConstantes.CONSTANTE_EMPRESA.equals(param.getTipoempresa())){
			lista= W83bFactoriaDAO.getComunicacionesDAO().generarComunicComEmpresasFiscal(param);
		}
		else if (W83bClsConstantes.CONSTANTE_CENTRO.equals(param.getTipoempresa())){
			lista= W83bFactoriaDAO.getComunicacionesDAO().generarComunicComEmpresas(param);
		}
		if (!"comempresa".equals(param.getEscomunicacion())){
			return obtenerRestoComunicaciones(param,lista);
		}
		else{
			return obtenerComunicacion(param,lista);
		}
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bComunicaciones#generarOficioRequeMesa(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List generarOficioRequeMesa(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
	
		List lista= W83bFactoriaDAO.getComunicacionesDAO().generarOficioRequeMesa(param);
		return obtenerComunicacion(param,lista);	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bComunicaciones#generarComunicRequeMesa(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List generarComunicRequeMesa(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
	
		List lista= W83bFactoriaDAO.getComunicacionesDAO().generarComunicRequeMesa(param);
		if (!"oficio".equals(param.getEscomunicacion())&&!"requemesa".equals(param.getEscomunicacion())){
			return obtenerRestoComunicaciones(param,lista);
		}
		else{
			return obtenerComunicacion(param,lista);
		}	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bComunicaciones#w83bComunicImpugResueltas(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List w83bComunicImpugResueltas(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
	
		List lista= W83bFactoriaDAO.getComunicacionesDAO().w83bComunicImpugResueltas(param);
		List listaimpugn=new ArrayList();
		HashMap actas=new HashMap();
		boolean encontrado=false;
		for (int i=0; i<lista.size(); i++){
			listaimpugn=new ArrayList();//NOPMD
			W83bComunicacionesBean cb=(W83bComunicacionesBean)lista.get(i);
			String[] impugn=cb.getNimpug().split("\\,");
				for (int j=0;j<impugn.length;j++){
					String[] datosimpugn=impugn[j].split("\\|");
					if (datosimpugn.length<3){
						encontrado=false;
						if (actas.get(cb.getNacta()+"|"+cb.getAnoacta())==null){
							listaimpugn.add(datosimpugn[0]+"|"+datosimpugn[1]);
							actas.put(cb.getNacta()+"|"+cb.getAnoacta(), listaimpugn);
						}
						else{
							listaimpugn=(ArrayList)actas.get(cb.getNacta()+"|"+cb.getAnoacta());
							for (int h=0;h<listaimpugn.size();h++){
								if (listaimpugn.get(h).equals(datosimpugn[0]+"|"+datosimpugn[1])){
									encontrado=true;
									break;
								}
								if (!encontrado&&h==listaimpugn.size()-1){
									listaimpugn.add(datosimpugn[0]+"|"+datosimpugn[1]);
									actas.put(cb.getNacta()+"|"+cb.getAnoacta(), listaimpugn);
								}
							}
						}
					}
				}
		}
		for (int i=0; i<lista.size(); i++){
			W83bComunicacionesBean cb=(W83bComunicacionesBean)lista.get(i);
		    cb.setImpugn((ArrayList)actas.get(cb.getNacta()+"|"+cb.getAnoacta()));
		}
		lista.add("impug");
		if (!"impug".equals(param.getEscomunicacion())){
			return obtenerRestoComunicaciones(param,lista);
		}
		else{
			return obtenerComunicacion(param,lista);
		}
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bComunicaciones#w83bComunicLaudosResueltos(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List w83bComunicLaudosResueltos(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
	
		List lista=W83bFactoriaDAO.getComunicacionesDAO().w83bComunicLaudosResueltos(param);
		List listaimpugn=new ArrayList();
		HashMap actas=new HashMap();
		List listadef=new ArrayList();
		boolean encontrado=false;
		for (int i=0; i<lista.size(); i++){
			listaimpugn=new ArrayList();//NOPMD
			W83bComunicacionesBean cb=(W83bComunicacionesBean)lista.get(i);
			String[] impugn=cb.getNimpug().split("\\,");
			for (int j=0;j<impugn.length;j++){
				String[] datosimpugn=impugn[j].split("\\|");
				String fd=W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechalaudodesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO);
				String fh=W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechalaudohasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO);
				if ((!"0".equals(datosimpugn[2])&&W83bDateUtil.getInstance().compararfechas(W83bDateUtil.getInstance().getDate(datosimpugn[2],"dd/MM/yyyy"), W83bDateUtil.getInstance().getDate(fd,"dd/MM/yyyy"))&&
						W83bDateUtil.getInstance().compararfechas(W83bDateUtil.getInstance().getDate(fh,"dd/MM/yyyy"),W83bDateUtil.getInstance().getDate(datosimpugn[2],"dd/MM/yyyy")))||
						(!"0".equals(datosimpugn[3])&&W83bDateUtil.getInstance().compararfechas(W83bDateUtil.getInstance().getDate(datosimpugn[3],"dd/MM/yyyy"), W83bDateUtil.getInstance().getDate(fd,"dd/MM/yyyy"))&&
						W83bDateUtil.getInstance().compararfechas(W83bDateUtil.getInstance().getDate(fh,"dd/MM/yyyy"),W83bDateUtil.getInstance().getDate(datosimpugn[3],"dd/MM/yyyy")))){
					encontrado=false;
						if (actas.get(cb.getOrderby()+"|"+cb.getNacta()+"|"+cb.getAnoacta())==null){
							listaimpugn.add(datosimpugn[0]+"|"+datosimpugn[1]);
							actas.put(cb.getOrderby()+"|"+cb.getNacta()+"|"+cb.getAnoacta(), listaimpugn);
						}else{
							listaimpugn=(ArrayList)actas.get(cb.getOrderby()+"|"+cb.getNacta()+"|"+cb.getAnoacta());
							for (int h=0;h<listaimpugn.size();h++){
								if (listaimpugn.get(h).equals(datosimpugn[0]+"|"+datosimpugn[1])){
									encontrado=true;
									break;
								}
								if (!encontrado&&h==listaimpugn.size()-1){
									listaimpugn.add(datosimpugn[0]+"|"+datosimpugn[1]);
									actas.put(cb.getOrderby()+"|"+cb.getNacta()+"|"+cb.getAnoacta(), listaimpugn);
								}
							}
						}
				}
			}
		}
		List sind=new ArrayList();
		HashMap sinddef=new HashMap();
		for (int i=0; i<lista.size(); i++){
			W83bComunicacionesBean cb=(W83bComunicacionesBean)lista.get(i);
			listaimpugn=(ArrayList)actas.get(cb.getOrderby()+"|"+cb.getNacta()+"|"+cb.getAnoacta());
			if (listaimpugn!=null){
				if ("1".equals(cb.getOrderby())){
					for (int j=0;j<listaimpugn.size();j++){
						sind=W83bFactoriaDAO.getComunicacionesDAO().obtenerSindImpug((String)listaimpugn.get(j),cb.getTerrit(),param.getUsuarioBean());
						for (int h=0;h<sind.size();h++){
							W83bSindicatosBean s=(W83bSindicatosBean)sind.get(h);
							if (!W83bClsConstantes.codELA.equals(s.getCodSindicato())&&!W83bClsConstantes.codLAB.equals(s.getCodSindicato())&&!W83bClsConstantes.codCCOO.equals(s.getCodSindicato())&&!W83bClsConstantes.codUGT.equals(s.getCodSindicato())){
								sinddef.put(s.getCodSindicato(), s.getDescSindicatoCast()+"|"+s.getDescSindicatoEusk());
							}
							
						}
					}
				}
				cb.setImpugn((ArrayList)actas.get(cb.getOrderby()+"|"+cb.getNacta()+"|"+cb.getAnoacta()));
				cb.setSind(sinddef);
				listadef.add(cb);
				sinddef=new HashMap();//NOPMD
			}
		}
		listadef.add("laudo");
		if (!"laudo".equals(param.getEscomunicacion())){
			return obtenerRestoComunicaciones(param,listadef);
		}
		else{
			return obtenerComunicacion(param,listadef);
		}
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bComunicaciones#w83bComunicResolDeneg(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List w83bComunicResolDeneg(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
	
		List lista= W83bFactoriaDAO.getComunicacionesDAO().w83bComunicResolDeneg(param);
		return obtenerRestoComunicaciones(param,lista);
	}
	
	public java.util.List obtenerMunicipioProvincia(java.util.List lista) throws Exception{
		for (int i=0; i<lista.size()-1; i++){
			W83bComunicacionesBean registro = (W83bComunicacionesBean)lista.get(i);
			W83bComunicacionesBean mun=W83bFactoriaDAO.getComunicacionesDAO().obtenerMunicipio(registro);
			registro.setMunicipio(mun.getDescmunicipio());
			W83bComunicacionesBean prov=W83bFactoriaDAO.getComunicacionesDAO().obtenerProvincia(registro);
			registro.setProvincia(prov.getDescprovincia());
		}
		return lista;
	}
	
	public java.util.List obtenerComunicacion(w83b.w83bBeans.W83bComunicacionesBean param,java.util.List lista) throws Exception{
		String nombrefirmante="";
		String descfirmante="";
		String descfirmanteeu="";
		String sexo="";
		String[] dfirmante=param.getDescfirmante().split("\\/");
		if (!"".equals(param.getFirmante())){
			String n=(String)W83bFactoriaDAO.getComunicacionesDAO().obtenerDatosComunicacion(param);
			if (n!=null&&!("").equals(n)){
				String[] nombreysexo=n.split("\\|");
				nombrefirmante=nombreysexo[0];
				sexo=nombreysexo[1];
			}
			descfirmante=(String)W83bFactoriaDAO.getComunicacionesDAO().obtenerDescPerfil(param,sexo,W83bClsConstantes.CONSTANTE_CASTELLANO);
			descfirmanteeu=(String)W83bFactoriaDAO.getComunicacionesDAO().obtenerDescPerfil(param,sexo,W83bClsConstantes.CONSTANTE_EUSKARA);
		}
		param.setProvincia(param.getTerritorio());
		W83bComunicacionesBean provincia=W83bFactoriaDAO.getComunicacionesDAO().obtenerProvincia(param);
		for (int i=0;i<lista.size()-1;i++){
			W83bComunicacionesBean comunic=(W83bComunicacionesBean)lista.get(i);
			comunic.setCentroSel(param.getCentroSel());
			comunic.setUsuarioBean(param.getUsuarioBean());
			W83bComunicacionesBean mun=W83bFactoriaDAO.getComunicacionesDAO().obtenerMunicipio(comunic);
			comunic.setMunicipio(mun.getDescmunicipio());
			W83bComunicacionesBean prov=W83bFactoriaDAO.getComunicacionesDAO().obtenerProvincia(comunic);
			comunic.setProvincia(prov.getDescprovincia());
			comunic.setFechacomunicacion(param.getFechacomunicacion());
			comunic.setDescTerritorio(provincia.getDescprovincia());
			comunic.setNombrefirmante(nombrefirmante);
			comunic.setDescfirmante(descfirmante);
			comunic.setDescfirmanteeu(descfirmanteeu);
			comunic.setIdioma(param.getIdioma());
			comunic.setUsuarioBean(param.getUsuarioBean());
			comunic.setEscomunicacion(param.getEscomunicacion());
		}
		return lista;
	}
	
	public java.util.List obtenerRestoComunicaciones(w83b.w83bBeans.W83bComunicacionesBean param,java.util.List lista) throws Exception{
		for (int i=0;i<lista.size()-1;i++){
			W83bComunicacionesBean comunic=(W83bComunicacionesBean)lista.get(i);
			comunic.setCentroSel(param.getCentroSel());
			W83bComunicacionesBean mun=W83bFactoriaDAO.getComunicacionesDAO().obtenerMunicipio(comunic);
			comunic.setMunicipio(mun.getDescmunicipio());
			W83bComunicacionesBean prov=W83bFactoriaDAO.getComunicacionesDAO().obtenerProvincia(comunic);
			comunic.setProvincia(prov.getDescprovincia());
			comunic.setFechacomunicacion(param.getFechacomunicacion());
		}
		return lista;
	}
	
	public String actFechaReque(List param) throws Exception{
		
		String num=(String)W83bFactoriaDAO.getComunicacionesDAO().actFechaReque(param);
			
		return num;	
	}
	
	public java.util.List generarNumSalida(java.util.List param) throws Exception{
		//HashMap c=new HashMap();
		StringBuffer observaciones=new StringBuffer(W83bClsConstantes.CUARENTA);
		for (int i=0;i<param.size()-1;i++){
			W83bComunicacionesBean comunic=(W83bComunicacionesBean)param.get(i);
			observaciones=new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD

			observaciones.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.comunicaciones.notifemppre",comunic.getIdioma(),null)).append(" ");
			observaciones.append(comunic.getNumpreaviso());
			long milisegundos = System.currentTimeMillis();
			String [] resul=W83bLibroRegistro.getAltaRegistro(true, comunic.getUsuarioBean().getModeloSal(), "S", "E", Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",comunic.getIdioma(),null), comunic.getTerrit(), "" ,observaciones.toString(), comunic.getUsuarioBean());
			W83bClsTrazas.trazaError(comunic.getUsuarioBean(), "tiempo antes de query="+(System.currentTimeMillis()- milisegundos), null);
			comunic.setNumsalida(resul[0]);
			
		}
		return param;
	}
	
	public String insertarComunicInd(java.util.HashMap param) throws Exception{
		String num="";
		String tipodocumento="";
		boolean existe=false;
		List lista=(List)param.get("comunicind");
		tipodocumento=(String)W83bFactoriaDAO.getComunicacionesDAO().obtenerTipodocumento((W83bDocBean)lista.get(0));
		for (int i=0;i<lista.size();i++){
			W83bDocBean comunic=(W83bDocBean)lista.get(i);
			comunic.setTipoDocumento(tipodocumento);
			
			//Si es comunicacin de tipo acta aadimos la versin del acta
			if ("comempresa".equals(comunic.getEscomunicacion())||"requemesa".equals(comunic.getEscomunicacion())){
				W83bActasBean  actasBean = new W83bActasBean();
				actasBean.setNumActaTerritorio(comunic.getNumActaTerritorio());
				actasBean.setNumActa(comunic.getNumActa());
				actasBean.setNumActaAno(comunic.getNumActaAno());
				List listaActas = W83bFactoriaDAO.getActasDAO().buscarActaMaxVersionValidada(actasBean);
				comunic.setVersionActa(((HashMap)listaActas.get(0)).get(W83bActasBD.versionActa).toString());
			}
			
			if ("preaviso".equals(comunic.getEscomunicacion())){
				existe=(boolean)W83bFactoriaDAO.getComunicacionesDAO().existePreavisoTramite(comunic);
			}else if ("comempresa".equals(comunic.getEscomunicacion())||"requemesa".equals(comunic.getEscomunicacion())){
				existe=(boolean)W83bFactoriaDAO.getComunicacionesDAO().existeActaTramite(comunic);
			}else if ("impug".equals(comunic.getEscomunicacion())||"laudo".equals(comunic.getEscomunicacion())){
				existe=(boolean)W83bFactoriaDAO.getComunicacionesDAO().existeImpugTramite(comunic);
			}else if ("comunicacion".equals(comunic.getEscomunicacion())){
				existe=(boolean)W83bFactoriaDAO.getComunicacionesDAO().existeIncTramite(comunic);
			}
			if (existe){
				if ("preaviso".equals(comunic.getEscomunicacion())){
					num=(String)W83bFactoriaDAO.getComunicacionesDAO().modificarTramite(comunic);
				}else if ("comempresa".equals(comunic.getEscomunicacion())||"requemesa".equals(comunic.getEscomunicacion())){
					num=(String)W83bFactoriaDAO.getComunicacionesDAO().modificarTramiteActa(comunic);
				}else if ("impug".equals(comunic.getEscomunicacion())||"laudo".equals(comunic.getEscomunicacion())){
					num=(String)W83bFactoriaDAO.getComunicacionesDAO().modificarTramiteImpug(comunic);
				}else if ("comunicacion".equals(comunic.getEscomunicacion())){
					num=(String)W83bFactoriaDAO.getComunicacionesDAO().modificarTramiteInc(comunic);
				}
			}else{
				if ("preaviso".equals(comunic.getEscomunicacion())){
					num=(String)W83bFactoriaDAO.getComunicacionesDAO().insertarTramite(comunic);
				}else if ("comempresa".equals(comunic.getEscomunicacion())||"requemesa".equals(comunic.getEscomunicacion())){
					num=(String)W83bFactoriaDAO.getComunicacionesDAO().insertarTramiteActa(comunic);
				}else if ("impug".equals(comunic.getEscomunicacion())||"laudo".equals(comunic.getEscomunicacion())){
					num=(String)W83bFactoriaDAO.getComunicacionesDAO().insertarTramiteImpug(comunic);
				}else if ("comunicacion".equals(comunic.getEscomunicacion())){
					num=(String)W83bFactoriaDAO.getComunicacionesDAO().insertarTramiteInc(comunic);
				}
			}
			if ("preaviso".equals(comunic.getEscomunicacion())){
				num=(String)W83bFactoriaDAO.getComunicacionesDAO().insertarComunicInd(comunic);
			}else if ("comempresa".equals(comunic.getEscomunicacion())||"requemesa".equals(comunic.getEscomunicacion())){
				num=(String)W83bFactoriaDAO.getComunicacionesDAO().insertarComunicIndActa(comunic);
			}else if ("impug".equals(comunic.getEscomunicacion())||"laudo".equals(comunic.getEscomunicacion())){
				num=(String)W83bFactoriaDAO.getComunicacionesDAO().insertarComunicIndImpug(comunic);
			}else if ("comunicacion".equals(comunic.getEscomunicacion())){
				num=(String)W83bFactoriaDAO.getComunicacionesDAO().insertarComunicIndInc(comunic);
			}
		}
			
	return num;	
	}
	
	public java.util.List comunicExtraccionDatos(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		
		return W83bFactoriaDAO.getComunicacionesDAO().comunicExtraccionDatos(param);
	}
	
   /**
    * Devuelve el numero de comunicaciones de preavisos que se van a mandar a correspondencia
    * @param param the param
    * @return the java.lang.Integer
    * @throws Exception the exception
    */
   public java.lang.Integer obtenerNumPreavisosGenerarComunic( w83b.w83bBeans.W83bComunicacionesBean param ) throws Exception{
	   List preavisos =  this.obtenerPreavisosGenerarComunic(param);
	   return  new Integer(preavisos.size());
   }
   
   /**
    * Devuelve los preavisos de los que se va a enviar comunicacin
    * @param comunicacionBean the param
    * @return java.util.List
    * @throws Exception the exception
    */
	public java.util.List obtenerPreavisosGenerarComunic(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		
		List lista= new ArrayList();
		
		 //1. Recuperamos la lista de preavisos
		List preavisos = this.generarComunicPreaviso(param);
		
		//2. Obtenemos la lista de comunicaciones de preavisos
	   W83bDocBean docBean = new W83bDocBean();
	   docBean.setCodTramite("3");
	   docBean.setCodFase("1");
	   param.setIdTipoDocumento((String)W83bFactoriaDAO.getComunicacionesDAO().obtenerTipodocumento(docBean));
	   List comunicacionesPreavisos = W83bFactoriaDAO.getComunicacionesDAO().obtenerComunicacionesPreavisos(param);
	   
	 	//3.Recorremos los preavisos para comprobar que tienen comunicacion
	   for (int i = 0; i < preavisos.size(); i++) {
		   if(preavisos.get(i) instanceof  W83bComunicacionesBean){
			   W83bComunicacionesBean comunic=(W83bComunicacionesBean)preavisos.get(i);
			   if(comunicacionesPreavisos.contains(comunic.getTerrit()+"|"+comunic.getAnopreaviso()+"|"+comunic.getNpre())){
				   lista.add((W83bComunicacionesBean)preavisos.get(i));
			   }
		   }
	   }
	   
	   
	   return lista;
	}
	
	
   /**
    * Devuelve el numero de comunicaciones de actas que se van a mandar a correspondencia
    * @param param the param
    * @return the java.lang.Integer
    * @throws Exception the exception
    */
   public java.lang.Integer obtenerNumActasGenerarComunic( w83b.w83bBeans.W83bComunicacionesBean param ) throws Exception{
	   List actas =  this.obtenerActasGenerarComunic(param);
	   return  new Integer(actas.size());
   }
   
   
   /**
    * Devuelve los actas de los que se va a enviar comunicacin
    * @param comunicacionBean the param
    * @return java.util.List
    * @throws Exception the exception
    */
	public java.util.List obtenerActasGenerarComunic(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
	
		List lista= new ArrayList();
		
		//1. Recuperamos la lista de actas
		List actas = this.generarComunicComEmpresas(param);
		
		//2. Obtenemos la lista de comunicaciones de actas
	   W83bDocBean docBean = new W83bDocBean();
	   docBean.setCodTramite("3");
	   docBean.setCodFase("2");
	   param.setIdTipoDocumento((String)W83bFactoriaDAO.getComunicacionesDAO().obtenerTipodocumento(docBean));
	   List comunicacionesActas = W83bFactoriaDAO.getComunicacionesDAO().obtenerComunicacionesActas(param);
	   
	   
	 	//3.Recorremos las actas para comprobar que tienen comunicacion
	   for (int i = 0; i < actas.size(); i++) {
		   if(actas.get(i) instanceof  W83bComunicacionesBean){
			   W83bComunicacionesBean comunic=(W83bComunicacionesBean)actas.get(i);
			   if(comunicacionesActas.contains(comunic.getTerrit()+"|"+comunic.getAnoacta()+"|"+comunic.getNacta())){
				   lista.add((W83bComunicacionesBean)actas.get(i));
			   }
		   }
	   }
	   
	   return lista;
	}
	
	
	
	
	   /**
	    * Devuelve el numero de comunicaciones de actas que se van a mandar a correspondencia de requerimientos de mesa
	    * @param param the param
	    * @return the java.lang.Integer
	    * @throws Exception the exception
	    */
	   public java.lang.Integer obtenerNumActasGenerarComunicRequMesa( w83b.w83bBeans.W83bComunicacionesBean param ) throws Exception{
		   List actas =  this.obtenerActasGenerarComunicRequMesa(param);
		   return  new Integer(actas.size());
	   }
	   
	   
	   /**
	    * Devuelve los actas de los que se va a enviar comunicacin de requerimientos de mesa
	    * @param comunicacionBean the param
	    * @return java.util.List
	    * @throws Exception the exception
	    */
		public java.util.List obtenerActasGenerarComunicRequMesa(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		
			List lista= new ArrayList();
			
			//1. Recuperamos la lista de actas
			List actas = this.generarComunicRequeMesa(param);
			
			//2. Obtenemos la lista de comunicaciones de actas
		   W83bDocBean docBean = new W83bDocBean();
		   docBean.setCodTramite("4");
		   docBean.setCodFase("2");
		   param.setIdTipoDocumento((String)W83bFactoriaDAO.getComunicacionesDAO().obtenerTipodocumento(docBean));
		   List comunicacionesActas = W83bFactoriaDAO.getComunicacionesDAO().obtenerComunicacionesActas(param);
		   
		 //3.Recorremos las actas para comprobar que tienen comunicacion
		   for (int i = 0; i < actas.size(); i++) {
			   if(actas.get(i) instanceof  W83bComunicacionesBean){
				   W83bComunicacionesBean comunic=(W83bComunicacionesBean)actas.get(i);
				   if(comunicacionesActas.contains(comunic.getTerrit()+"|"+comunic.getAnoacta()+"|"+comunic.getNacta())){
					   lista.add((W83bComunicacionesBean)actas.get(i));
				   }
			   }
		   }
		   
		   return lista;

		}
		
		
	   /**
	    * Devuelve el numero de comunicaciones de actas que se van a mandar a correspondencia de requerimientos de mesa
	    * @param param the param
	    * @return the java.lang.Integer
	    * @throws Exception the exception
	    */
	   public java.lang.Integer obtenerNumActasGenerarComunicResolDeneg( w83b.w83bBeans.W83bComunicacionesBean param )throws Exception{
		   
		   
		   //TODO NO ENCUENTRO DONDE SE GENERA ESTA COMUNICACIN CON LO QUE NO SE QUE TIPO DE TRAMITE O FASE LLEVA
		   //SE QUEDA PARADO HASTA ESE MOMENTO

		   return null;
		   
	   }
	   
	   
		
	   /**
	    * Devuelve el numero de comunicaciones de impugnaciones resueltas que se van a mandar a correspondencia
	    * @param param the param
	    * @return the java.lang.Integer
	    * @throws Exception the exception
	    */
	   public java.lang.Integer obtenerNumImpugResueltasGenerarComunic( w83b.w83bBeans.W83bComunicacionesBean param ) throws Exception{
		   List impuganciones =  this.obtenerImpugResueltasGenerarComunic(param);
		   return  new Integer(impuganciones.size()); 
	   }
	   
	   
	   /**
		* Devuelve impugnaciones resueltas de los que se va a enviar comunicacin
	    * @param comunicacionBean the param
	    * @return java.util.List
	    * @throws Exception the exception
	    */
		public java.util.List obtenerImpugResueltasGenerarComunic(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
			
			List lista= new ArrayList();
			
		   //1. Recuperamos la lista de impuganaciones resueltas
		   List impugResueltas = this.w83bComunicImpugResueltas(param);
		
		   //2.Obtenemos la lista de comunicaciones de impugnaciones resueltas
		   W83bDocBean docBean = new W83bDocBean();
		   docBean.setCodTramite("2");
		   docBean.setCodFase("5");
		   param.setIdTipoDocumento((String)W83bFactoriaDAO.getComunicacionesDAO().obtenerTipodocumento(docBean));
		   List comunicacionesImpugResueltas = W83bFactoriaDAO.getComunicacionesDAO().obtenerComunicacionesImpugnaciones(param);
		   
		   
		   //3.Recorremos las impugnaciones para comprobar que tienen comunicacion
		   for (int i = 0; i < impugResueltas.size(); i++) {
			   if(impugResueltas.get(i) instanceof  W83bComunicacionesBean){
				   String[] impugn = ((W83bComunicacionesBean)impugResueltas.get(i)).getNimpug().split("\\,");
				   for (int j=0;j<impugn.length;j++){
						String[] datosimpugn=impugn[j].split("\\|");
						if(comunicacionesImpugResueltas.contains(datosimpugn[0]+"|"+datosimpugn[1])){
							lista.add(impugResueltas.get(i));
							break;
						}
					}
			   }
		   }
		   
		   
		   return lista;
		   
		}
		
		
	   /**
	    * Devuelve el numero de comunicaciones de laudos resueltos que se van a mandar a correspondencia
	    * @param param the param
	    * @return the java.lang.Integer
	    * @throws Exception the exception
	    */
	   public java.lang.Integer obtenerNumLaudosResueltosGenerarComunic( w83b.w83bBeans.W83bComunicacionesBean param ) throws Exception{
		   List comunicaciones =  this.obtenerLaudosResueltosGenerarComunic(param);
		   return  new Integer(comunicaciones.size());
	   }
	   
	   
	   /**
		* Devuelve impugnaciones resueltas de los que se va a enviar comunicacin
	    * @param comunicacionBean the param
	    * @return java.util.List
	    * @throws Exception the exception
	    */
		public java.util.List obtenerLaudosResueltosGenerarComunic(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
			
			List lista= new ArrayList();
			
		   //1. Recuperamos la lista de impuganaciones resueltas
		   List laudosResueltos = this.w83bComunicLaudosResueltos(param);
		
		   //2.Obtenemos la lista de comunicaciones de impugnaciones resueltas
		   W83bDocBean docBean = new W83bDocBean();
		   docBean.setCodTramite("5");
		   docBean.setCodFase("5");
		   param.setIdTipoDocumento((String)W83bFactoriaDAO.getComunicacionesDAO().obtenerTipodocumento(docBean));
		   List comunicacionesLaudosResueltos = W83bFactoriaDAO.getComunicacionesDAO().obtenerComunicacionesImpugnaciones(param);
		   
		   
		   //3.Recorremos las impugnaciones para comprobar que tienen comunicacion
		   for (int i = 0; i < laudosResueltos.size(); i++) {
			   if(laudosResueltos.get(i) instanceof  W83bComunicacionesBean){
				   W83bComunicacionesBean comunic=(W83bComunicacionesBean)laudosResueltos.get(i);
				   for (int h=0;h<comunic.getImpugn().size();h++){
					   	String imp=(String)comunic.getImpugn().get(h);
						String[] datosimpug=imp.split("\\|");
						if(comunicacionesLaudosResueltos.contains(datosimpug[0]+"|"+datosimpug[1])){
							//Aadimos la comunicacin a la lista
							comunic.setDestinatarioComunicLaudo(W83bClsConstantes.DESTINATARIO_LAUDO_CENTRO);
							lista.add(comunic);

							
							if ("1".equals(comunic.getOrderby())){
								
								//Aadimos una comunicacin para el presidente
								W83bComunicacionesBean comunicPresindente =  (W83bComunicacionesBean) comunic.clone();
								comunicPresindente.setDestinatarioComunicLaudo(W83bClsConstantes.DESTINATARIO_LAUDO_PRESIDENTE);
								lista.add(comunicPresindente);
								
								//Aadimos comunicaciones para sindicatos 
								if (!comunic.getSind().isEmpty()){
									Iterator it = comunic.getSind().keySet().iterator();
									while (it.hasNext()){
										String codSindicato = (String)it.next();
										W83bComunicacionesBean comunicsindicato = (W83bComunicacionesBean) comunic.clone();
										comunicsindicato.setDestinatarioComunicLaudo(codSindicato);
										lista.add(comunicsindicato);
									}
								}
							}
							
							break;
						}
					}
			   }
		   }
		   
		   return lista;
		   
		}
		
		
	   /**
	    * Devuelve el numero de comunicaciones de incidencias que se van a mandar a correspondencia
	    * @param param the param
	    * @return the java.lang.Integer
	    * @throws Exception the exception
	    */
	   public java.lang.Integer obtenerNumIncidenciasGenerarComunic(w83b.w83bBeans.W83bComunicacionesBean param)throws Exception{
		   List incidencias =  this.obtenerIncidenciasGenerarComunic(param);
		   return  new Integer(incidencias.size());
		   
	   }
	   
	   
	   /**
	    * Devuelve las incidencias de los que se va a enviar comunicacin
	    * @param comunicacionBean the param
	    * @return java.util.List
	    * @throws Exception the exception
	    */
		public java.util.List obtenerIncidenciasGenerarComunic(w83b.w83bBeans.W83bComunicacionesBean param) throws Exception{
		
			List lista= new ArrayList();
			
			 //1. Recuperamos la lista de incidencias
			List incidencias = this.generarComunicIncidencias(param);
			
			//2.Obtenemos la lista de comunicaciones de incidencias
			W83bDocBean docBean = new W83bDocBean();
			docBean.setCodTramite("2");
			docBean.setCodFase("6");
			param.setIdTipoDocumento((String)W83bFactoriaDAO.getComunicacionesDAO().obtenerTipodocumento(docBean));
			List comunicacionesIncidencias = W83bFactoriaDAO.getComunicacionesDAO().obtenerComunicacionesIncidencias(param);
		   
			
		   //3.Recorremos las incidencias para comprobar que tienen comunicacion
		   for (int i = 0; i < incidencias.size(); i++) {
			   if(incidencias.get(i) instanceof  W83bComunicacionesBean){
				   W83bComunicacionesBean comunic=(W83bComunicacionesBean)incidencias.get(i);
				   if(comunicacionesIncidencias.contains(comunic.getTerrit()+"|"+comunic.getAnoincidencia()+"|"+comunic.getNumincidencia())){
					   lista.add((W83bComunicacionesBean)incidencias.get(i));
				   }
			   }
		   }
		   
		   return lista;
		}
	
}